//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "gpioUseCasePage.h"

@interface gpioUseCasePage ()

@end

@implementation gpioUseCasePage

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initViewUIElements];
    [self setAutoHideDropDownMenuListener];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    [self SetI2cSlaveUI];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData){
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    [self SetI2cMasterUI];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    [self SetGpioUI];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    [self SetGetUseCaseConfigOptionSelectedView];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)padConfigCh0OptionsTap:(id)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
    
    [_padConfigCh0DropDown.layer addAnimation:animation forKey:nil];
    _padConfigCh0DropDown.hidden     = NO;
}

- (IBAction)receiverDisabledCh0Selected:(id)sender {
    
    _padConfigCh0DropDown.hidden           = true;
    _padConfigCh0OptionChosenLabel.text   = str_receiver_disabled00b;
}

- (IBAction)weakPullUpCh0Selected:(id)sender {
    _padConfigCh0DropDown.hidden           = true;
    _padConfigCh0OptionChosenLabel.text   = str_plain_input_pullup01b;
}

- (IBAction)plainInputCh0Selected:(id)sender {
    _padConfigCh0DropDown.hidden           = true;
    _padConfigCh0OptionChosenLabel.text   = str_plain_input10b;
}

- (IBAction)weakPullDownCh0Selected:(id)sender {
    _padConfigCh0DropDown.hidden           = true;
    _padConfigCh0OptionChosenLabel.text   = str_plain_input_weak_pulldown11b;
}

- (IBAction)readConfigButtonClick:(UIButton *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        [[GPIOUseCase sharedInstance] readGPIO:^(NSData *aData, const int order) {
            if (order == 0){
                [self writeLog:cmd_readGPIOPWMConfig response:aData];
                
            } else if (order == 1){
                [self writeLog:cmd_readTagConfig response:aData];
                [self updateUIWithSecondReadCommand:aData];
            }
            
        } onFailure:^(NSError *error) {
            return;
        }];
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)clearGPIOOutputButtonClick:(UIButton *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[GPIOUseCase sharedInstance] clearGPIOOutput:^(NSData *aData) {
            [self writeLog:cmd_gpioClearSessionOutput response:aData];
            
            [[NSOperationQueue mainQueue] addOperationWithBlock:^{
                self->_bulbImageView.image = [UIImage imageNamed: img_off_bulb];
            }];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)bulbTap:(UIGestureRecognizer *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[GPIOUseCase sharedInstance] pushGPIOOutput:^(NSData *aData) {
            [self writeLog:cmd_gpioClearSessionOutput response:aData];
            [[NSOperationQueue mainQueue] addOperationWithBlock:^{
                self->_bulbImageView.image = [UIImage imageNamed: img_on_bulb];
            }];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)getInputStatusButtonClick:(UIButton *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[GPIOUseCase sharedInstance] getGPIOInput:^(NSData *aData) {
            [self writeLog:cmd_readTagStatus response:aData];
            [self updateUIWithGPIOInputCommand:aData];
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)writeConfigButtonClick:(UIButton *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        ISO15693Command *tagConfig  = [self getTagConfigGPIOCommand];
        ISO15693Command *tagSession = [self getTagSessionGPIOCommand];
        
        [[GPIOUseCase sharedInstance] writeGPIO:tagConfig getTagConfig:tagSession onSuccess:^(NSData *aData){
            [self writeLog:tagSession.getNSStringCommand response:aData];
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (void)DoInitSession {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
}

- (void)CheckTagData:(char *)data {
    if([_slewRateOptionChosenLabel.text
        isEqual: str_high_speed_gpio1b])
        data[2] |= 0x01;
    if([self->_slewRateCh2OptionChosenLabel.text
        isEqual: str_high_speed_gpio1b])
        data[2] |= 0x02;
    if ([self->_padConfigCh0OptionChosenLabel.text
         isEqual:str_receiver_disabled00b])
        data[2] |= 0x00;
    else if ([self->_padConfigCh0OptionChosenLabel.text
              isEqual:str_plain_input_pullup01b])
        data[2] |= 0x10;
    else if ([self->_padConfigCh0OptionChosenLabel.text
              isEqual:str_plain_input10b])
        data[2] |= 0x20;
    else if ( [self->_padConfigCh0OptionChosenLabel.text
               isEqual:str_plain_input_weak_pulldown11b])
        data[2] |= 0x30;
    if ([self->_padConfigOptionSelected.text
           isEqual:str_receiver_disabled00b])
          data[2] |= 0x00;
      else if ([self->_padConfigOptionSelected.text
                isEqual:str_plain_input_pullup01b])
          data[2] |= 0x40;
      else if ([self->_padConfigOptionSelected.text
                isEqual:str_plain_input10b])
          data[2] |= 0x80;
      else if ( [self->_padConfigOptionSelected.text
                 isEqual:str_plain_input_weak_pulldown11b])
          data[2] |= 0xC0;
}

- (void) updateUIWithSecondReadCommand: (NSData *) response{
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        const char *tagConfigBytes                   = [response bytes];
        
        if ((tagConfigBytes[2] & 0xC0) == 0x00){
            
            self->_padConfigOptionSelected.text      = str_receiver_disabled00b;
            
        }  else if ((tagConfigBytes[2] & 0xC0) == 0x40){
            
            self->_padConfigOptionSelected.text      = str_plain_input_pullup01b;
            
        }  else if ((tagConfigBytes[2] & 0xC0) == 0x80){
            
            self->_padConfigOptionSelected.text      = str_plain_input10b;
            
        }  else if ((tagConfigBytes[2] & 0xC0) == 0xC0){
            
            self->_padConfigOptionSelected.text      = str_plain_input_weak_pulldown11b;
        }
        
        if ((tagConfigBytes[2] & 0x30) == 0x00){
            
            self->_padConfigCh0OptionChosenLabel.text      = str_receiver_disabled00b;
            
        }  else if ((tagConfigBytes[2] & 0x30) == 0x10){
            
            self->_padConfigCh0OptionChosenLabel.text      = str_plain_input_pullup01b;
            
        }  else if ((tagConfigBytes[2] & 0x30) == 0x20){
            
            self->_padConfigCh0OptionChosenLabel.text      = str_plain_input10b;
            
        }  else if ((tagConfigBytes[2] & 0x30) == 0x30){
            
            self->_padConfigCh0OptionChosenLabel.text      = str_plain_input_weak_pulldown11b;
        }
        
        if((tagConfigBytes[2] & 0x03) == 0x00){
            
            self->_slewRateOptionChosenLabel.text    = str_low_speed_gpio0b;
            self->_slewRateCh2OptionChosenLabel.text = str_low_speed_gpio0b;
            
        } else if ((tagConfigBytes[2] & 0x03)  == 0x01){
            
            self->_slewRateOptionChosenLabel.text    = str_high_speed_gpio1b;
            self->_slewRateCh2OptionChosenLabel.text = str_low_speed_gpio0b;
            
        } else if ((tagConfigBytes[2] & 0x03)  == 0x02){
            
            self->_slewRateOptionChosenLabel.text    = str_low_speed_gpio0b;
            self->_slewRateCh2OptionChosenLabel.text = str_high_speed_gpio1b;
            
        } else if ((tagConfigBytes[2] & 0x03)  == 0x03){
            
            self->_slewRateOptionChosenLabel.text    = str_high_speed_gpio1b;
            self->_slewRateCh2OptionChosenLabel.text = str_high_speed_gpio1b;
        }
        
        self->_buttonImageView.image                 = [UIImage imageNamed:img_unpressed_button];
    }];
}

- (void) updateUIWithGPIOInputCommand: (NSData *) response{
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        const char *resp                             = [response bytes];
        
        if ((resp[1] & 0x10) == 0x10){
            
            self->_buttonImageView.image             = [UIImage imageNamed:img_pressed_button];
        }else{
            
            self->_buttonImageView.image             = [UIImage imageNamed:img_unpressed_button];
        }
    }];
}

- (ISO15693Command *) getTagConfigGPIOCommand{
    ISO15693Command *tagConfigCommand;
    
    char data []  = {0x00, 0x20, 0x08, 0x00};
    
    [self CheckTagData:data];
    
    NSString *hexString = [Utils hexStringWithData:data ofLength:sizeof(data)];
    NSString *strCmd    = [NSString stringWithFormat:@"%@%@", cmd_writeTagConfig, hexString];
    
    tagConfigCommand    = [[ISO15693Command alloc]initWithData:strCmd];
    
    return tagConfigCommand;
}

- (ISO15693Command *) getTagSessionGPIOCommand{
    ISO15693Command *tagConfigCommand;
    
    char data []  = {0x00, 0x20, 0x08, 0x00};
    
    if([_slewRateOptionChosenLabel.text
        isEqual:str_high_speed_gpio1b])
        data[2] |= 0x01;
    
    if([self->_slewRateCh2OptionChosenLabel.text
        isEqual:str_high_speed_gpio1b])
        data[2] |= 0x02;
    
    if ([self->_padConfigCh0OptionChosenLabel.text
         isEqual:str_receiver_disabled00b])
        data[2] |= 0x00;
    
    else if ([self->_padConfigCh0OptionChosenLabel.text
              isEqual:str_plain_input_pullup01b])
        data[2] |= 0x10;
    
    else if ([self->_padConfigCh0OptionChosenLabel.text
              isEqual:str_plain_input10b])
        data[2] |= 0x20;
    
    else if ( [self->_padConfigCh0OptionChosenLabel.text
               isEqual:str_plain_input_weak_pulldown11b])
        data[2] |= 0x30;
    
    if ([self->_padConfigOptionSelected.text
         isEqual:str_receiver_disabled00b])
        data[2] |= 0x00;
    
    else if ([self->_padConfigOptionSelected.text
              isEqual:str_plain_input_pullup01b])
        data[2] |= 0x40;
    
    else if ([self->_padConfigOptionSelected.text
              isEqual:str_plain_input10b])
        data[2] |= 0x80;
    
    else if ( [self->_padConfigOptionSelected.text
               isEqual:str_plain_input_weak_pulldown11b])
        data[2] |= 0xC0;
    
    NSString *hexString = [Utils hexStringWithData:data ofLength:sizeof(data)];
    
    NSString *strCmd = [NSString stringWithFormat:@"%@%@", cmd_writeTagConfigSession, hexString];
    
    tagConfigCommand = [[ISO15693Command alloc]initWithData:strCmd];
    
    return tagConfigCommand;
}

/*---------------------- UI METHODS ----------------------*/

- (void) writeLog: (NSString *) cmd response: (NSData *) resp{
    NSMutableString * sbuf = [[Utils alloc] convertNSDataBytesToHexString:resp];
    NSString *log = [NSString stringWithFormat: @"NFC -> %@ \nTAG <- 00%@",
                     cmd, sbuf];
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        self-> _logsTextView.text = log;
        
        //Get the file path
        NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        NSString *fileName = [documentsDirectory stringByAppendingPathComponent:@"GPIOLogs.txt"];

        //create file if it doesn't exist
        if(![[NSFileManager defaultManager] fileExistsAtPath:fileName])
            [[NSFileManager defaultManager] createFileAtPath:fileName contents:nil attributes:nil];

        //append text to file (you'll probably want to add a newline every write)
        NSFileHandle *file = [NSFileHandle fileHandleForUpdatingAtPath:fileName];
        [file seekToEndOfFile];
        [file writeData:[log dataUsingEncoding:NSUTF8StringEncoding]];
        [file closeFile];
    }];
}

- (CATransition *)StartAnimationTransition {
    CATransition *animation         = [CATransition animation];
    animation.type = kCATransitionReveal;
    animation.duration              = 0.1;
    return animation;
}

-(void)HideWhenTappedAnywhere{
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
    
    [_padConfigCh0DropDown.layer addAnimation:animation forKey:nil];
     _padConfigCh0DropDown.hidden     = YES;
    
}

- (void)setAutoHideDropDownMenuListener {
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    singleTap.numberOfTapsRequired = 1;
    
    [self.MainView setUserInteractionEnabled:YES];
    [self.MainView addGestureRecognizer:singleTap];
}

- (void)initViewUIElements {
    _channel0View.layer.cornerRadius = 8;
    _channel0View.layer.borderColor  = [UIColor lightGrayColor].CGColor;
    _channel0View.layer.borderWidth  = 0.75;
    _channel0View.backgroundColor    = UIColor.whiteColor;
    
    _borderCh1View.layer.cornerRadius = 8;
    _borderCh1View.layer.borderColor  = [UIColor lightGrayColor].CGColor;
    _borderCh1View.layer.borderWidth  = 0.75;
    _borderCh1View.backgroundColor    = UIColor.whiteColor;
    _channel1View.backgroundColor     = UIColor.whiteColor;
    _channel1View.layer.cornerRadius  = 8;
    
    _bulbImageView.userInteractionEnabled           = true;
    
    _gpioSpeedDropDownList.userInteractionEnabled   = true;
    
    _clearGpioOutputButton.layer.cornerRadius       = 8;
    _getInputStatusButton.layer.cornerRadius        = 8;
    _writeConfigButon.layer.cornerRadius            = 8;
    _readConfigButton.layer.cornerRadius            = 8;
    
    _logsTextView.userInteractionEnabled            = false;
    
    _slewRateCh1ListView.userInteractionEnabled     = true;
    _slewRateCh1ListView.layer.borderColor          = [UIColor lightGrayColor].CGColor;
    _slewRateCh1ListView.layer.borderWidth          = 0.75;
    _slewrateCh1LowSpeedView.userInteractionEnabled = true;
    _slewrateCh1HighSpeedView.userInteractionEnabled        = true;
    
    _slewRateCh2ListView.userInteractionEnabled             = true;
    _slewRateCh2ListView.backgroundColor                    = UIColor.whiteColor;
    _slewRateCh2ListView.layer.borderColor                  = [UIColor lightGrayColor].CGColor;
    _slewRateCh2ListView.layer.borderWidth                  = 0.75;
    _slewrateCh2LowSpeedView.userInteractionEnabled         = true;
    _slewrateCh2HighSpeedView.userInteractionEnabled        = true;
    
    _padConfigList.userInteractionEnabled           = true;
    _padConfigList.backgroundColor                  = UIColor.whiteColor;
    _padConfigList.layer.borderColor                = [UIColor lightGrayColor].CGColor;
    _padConfigList.layer.borderWidth                = 0.75;
    
    _configDropDownList.userInteractionEnabled      = true;
    _configDropDownList.backgroundColor             = UIColor.whiteColor;
    _configDropDownList.layer.borderColor           = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth           = 0.75;
    _configDropDownList.hidden                      = true;
    
    _padConfigCh0DropDown.userInteractionEnabled      = true;
    _padConfigCh0DropDown.backgroundColor             = UIColor.whiteColor;
    _padConfigCh0DropDown.layer.borderColor           = [UIColor lightGrayColor].CGColor;
    _padConfigCh0DropDown.layer.borderWidth           = 0.75;
    _padConfigCh0DropDown.hidden                      = true;
}

- (void)SetI2cSlaveUI {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
}

- (void)SetI2cMasterUI {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
}

- (void)SetGetUseCaseConfigOptionSelectedView {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
}

- (void)SetGpioUI {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden       = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden            = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden      = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden      = YES;
}

- (IBAction)slewRateCh1LosSpeedTap:(UIGestureRecognizer *)sender {
    _slewRateCh1ListView.hidden     = true;
    _slewRateOptionChosenLabel.text = str_low_speed_gpio0b;
}

- (IBAction)slewRateCh1HighSpeedTap:(UIGestureRecognizer *)sender {
    _slewRateCh1ListView.hidden     = true;
    _slewRateOptionChosenLabel.text = str_high_speed_gpio1b;
}

- (IBAction)slewRateCh1Tap:(UIGestureRecognizer *)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = NO;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
    
    [_padConfigCh0DropDown.layer addAnimation:animation forKey:nil];
    _padConfigCh0DropDown.hidden     = YES;
    
}

- (IBAction)slewRateCh2Tap:(UIGestureRecognizer *)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = NO;
    
    [_padConfigCh0DropDown.layer addAnimation:animation forKey:nil];
    _padConfigCh0DropDown.hidden     = YES;
}

- (IBAction)padConfigOptionsTap:(UIGestureRecognizer *)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = NO;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
    
    [_padConfigCh0DropDown.layer addAnimation:animation forKey:nil];
    _padConfigCh0DropDown.hidden     = YES;
}

- (IBAction)receiverDisabledSelected:(UIGestureRecognizer *)sender {
    _padConfigList.hidden           = true;
    _padConfigOptionSelected.text   = str_receiver_disabled00b;
}

- (IBAction)weakPullUpSelected:(UIGestureRecognizer *)sender {
    _padConfigList.hidden           = true;
    _padConfigOptionSelected.text   = str_plain_input_pullup01b;
}

- (IBAction)plainInputSelected:(UIGestureRecognizer *)sender {
    _padConfigList.hidden           = true;
    _padConfigOptionSelected.text   = str_plain_input10b;
}

- (IBAction)weakPullDownSelected:(UIGestureRecognizer *)sender {
    _padConfigList.hidden           = true;
    _padConfigOptionSelected.text   = str_plain_input_weak_pulldown11b;
}

- (IBAction)slewRateCh2LowSpeedOptionSelected:(id)sender {
    _slewRateCh2ListView.hidden        = true;
    _slewRateCh2OptionChosenLabel.text = str_low_speed_gpio0b;
}

- (IBAction)slewRateCh2HighSpeedOptionSelected:(id)sender {
    _slewRateCh2ListView.hidden        = true;
    _slewRateCh2OptionChosenLabel.text = str_high_speed_gpio1b;
}

- (IBAction)navBarButtonClick:(id)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false)
        _configDropDownList.hidden  = true;
    else
        _configDropDownList.hidden  = false;
    
    [_padConfigList.layer addAnimation:animation forKey:nil];
    _padConfigList.hidden           = YES;
    
    [_slewRateCh1ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh1ListView.hidden     = YES;
    
    [_slewRateCh2ListView.layer addAnimation:animation forKey:nil];
    _slewRateCh2ListView.hidden     = YES;
}

@end
